unit FormOsoby;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, Mask, Buttons, DB;

type
  TFOsoby = class(TForm)
    GroupBox1: TGroupBox;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    meNazwisko: TMaskEdit;
    meImie: TMaskEdit;
    meMcowosc: TMaskEdit;
    meUlicaInr: TMaskEdit;
    meKodp: TMaskEdit;
    meMiasto: TMaskEdit;
    mePesel: TMaskEdit;
    dtpDataUr: TDateTimePicker;
    procedure BitBtn1Click(Sender: TObject);
  private
    { Private declarations }
    tryb_edit : Boolean;
    idosoby   : integer;
  public
    { Public declarations }
    // ustawiam kontrolki ekranowe
    procedure   set_idosoby(Value: integer);
    procedure   set_nazwisko(Value: String);
    procedure   set_imie(Value: String);
    procedure   set_dataur(Value: TDateTime);
    procedure   set_mcowosc(Value: String);
    procedure   set_ulicainr(Value: String);
    procedure   set_kodp(Value: String);
    procedure   set_miasto(Value: String);
    procedure   set_pesel(Value: String);

    // pobieram wartoci z kontrolek ekranowych
    function    get_idosoby(): Integer;
    function    get_nazwisko(): String;
    function    get_imie(): String;
    function    get_dataur(): TDateTime;
    function    get_mcowosc(): String;
    function    get_ulicainr(): String;
    function    get_kodp(): String;
    function    get_miasto(): String;
    function    get_pesel(): String;

    procedure   my_edit();
    procedure   my_insert();

    constructor Create(AOwner: TComponent; par_tryb: Boolean);
  end;

var
  FOsoby: TFOsoby;

implementation
{$R *.dfm}
Uses
   DataModule;

constructor TFOsoby.Create(AOwner: TComponent; par_tryb: Boolean);
begin
   inherited Create(AOwner);

   tryb_edit := par_tryb;

   if tryb_edit = True then begin
      set_idosoby(DM.ADODataSetBrowse.FieldByName('IDOSOBY').AsInteger);
      set_nazwisko(DM.ADODataSetBrowse.FieldByName('NAZWISKO').AsString);
      set_imie(DM.ADODataSetBrowse.FieldByName('IMIE').AsString);
      set_dataur(DM.ADODataSetBrowse.FieldByName('DATAUR').AsDateTime);
      set_mcowosc(DM.ADODataSetBrowse.FieldByName('MCOWOSC').AsString);
      set_ulicainr(DM.ADODataSetBrowse.FieldByName('ULICAINR').AsString);
      set_kodp(DM.ADODataSetBrowse.FieldByName('KODP').AsString);
      set_miasto(DM.ADODataSetBrowse.FieldByName('MIASTO').AsString);
      set_pesel(DM.ADODataSetBrowse.FieldByName('PESEL').AsString);
   end
   else begin
      set_nazwisko('');
      set_imie('');
      set_dataur(Now());
      set_mcowosc('');
      set_ulicainr('');
      set_kodp('');
      set_miasto('');
      set_pesel('');
   end;
end;

procedure TFOsoby.set_idosoby(Value: integer);
begin
   idosoby := Value;
end;

procedure TFOsoby.set_nazwisko(Value: String);
begin
   meNazwisko.Text := Value;
end;

procedure TFOsoby.set_imie(Value: String);
begin
   meImie.Text := Value;
end;

procedure TFOsoby.set_dataur(Value: TDateTime);
begin
   dtpDataur.Date := Value;
end;

procedure TFOsoby.set_mcowosc(Value: String);
begin
   meMcowosc.Text := Value;
end;

procedure TFOsoby.set_ulicainr(Value: String);
begin
   meUlicaInr.Text := Value;
end;

procedure TFOsoby.set_kodp(Value: String);
begin
   meKodp.Text := Value;
end;

procedure TFOsoby.set_miasto(Value: String);
begin
   meMiasto.Text := Value;
end;

procedure TFOsoby.set_pesel(Value: String);
begin
   mePesel.Text := Value;
end;

procedure TFOsoby.BitBtn1Click(Sender: TObject);
begin
   if meNazwisko.Text = '' then begin
      meNazwisko.Color := clred;
      Modalresult := mrNone;
      EXIT;
   end;


   if tryb_edit then begin
      my_edit();
   end
   else begin
      my_insert();
   end;
end;

function TFOsoby.get_idosoby(): Integer;
begin
   result := idosoby;
end;

function TFOsoby.get_nazwisko(): String;
begin
   result := meNazwisko.Text;
end;

function TFOsoby.get_imie(): String;
begin
   result := meImie.Text;
end;
function TFOsoby.get_dataur(): TDateTime;
begin
   result := dtpDataUr.Date;
end;

function TFOsoby.get_mcowosc(): String;
begin
   result := meMcowosc.Text;
end;

function TFOsoby.get_ulicainr(): String;
begin
   result := meUlicaINr.Text;
end;

function TFOsoby.get_kodp(): String;
begin
   result := meKodp.Text;
end;

function TFOsoby.get_miasto(): String;
begin
   result := meMiasto.Text;
end;

function TFOsoby.get_pesel(): String;
begin
   result := mePesel.Text;
end;

procedure TFOsoby.my_edit();
var
   zakladka : TBookMark;

begin
   zakladka := DM.ADODataSetBrowse.GetBookmark();
   
   with DM.adocEDIT do begin
      Parameters.ParamByName('IDOSOBY').Value  := get_idosoby();
      Parameters.ParamByName('NAZWISKO').Value := get_nazwisko();
      Parameters.ParamByName('IMIE').Value     := get_imie();
      Parameters.ParamByName('DATAUR').Value   := get_dataur();
      Parameters.ParamByName('MCOWOSC').Value  := get_mcowosc();
      Parameters.ParamByName('ULICAINR').Value := get_ulicainr();
      Parameters.ParamByName('KODP').Value     := get_kodp();
      Parameters.ParamByName('MIASTO').Value   := get_miasto();
      Parameters.ParamByName('PESEL').Value    := get_pesel();

      try
         Execute();
      finally
         // odswie ekran
         DM.ADODataSetBrowse.Close();
         DM.ADODataSetBrowse.Open();

         DM.ADODataSetBrowse.GotoBookmark(zakladka);
         DM.ADODataSetBrowse.FreeBookmark(zakladka);
      end;
   end;
end;

procedure TFOsoby.my_insert();
begin
   with DM.adocINSERT do begin
      Parameters.ParamByName('NAZWISKO').Value := get_nazwisko();
      Parameters.ParamByName('IMIE').Value     := get_imie();
      Parameters.ParamByName('DATAUR').Value   := get_dataur();
      Parameters.ParamByName('MCOWOSC').Value  := get_mcowosc();
      Parameters.ParamByName('ULICAINR').Value := get_ulicainr();
      Parameters.ParamByName('KODP').Value     := get_kodp();
      Parameters.ParamByName('MIASTO').Value   := get_miasto();
      Parameters.ParamByName('PESEL').Value    := get_pesel();

      try
         Execute();
      finally
         // odswie ekran
         DM.ADODataSetBrowse.Close();
         DM.ADODataSetBrowse.Open();
      end;
   end;
end;

end.

